<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class="mb-3 text-end">
            <a class="btn btn-sm btn--base" href="<?php echo e(route('ticket.open')); ?>">
                <i class="las la-plus"></i>
                <?php echo app('translator')->get('Create Ticket'); ?>
            </a>
        </div>

        <div class="row justify-content-center">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body p-0">
                        <div class="table-responsive--md">
                            <table class="custom--table table">
                                <thead>
                                    <tr>
                                        <th><?php echo app('translator')->get('S.N.'); ?></th>
                                        <th><?php echo app('translator')->get('Subject'); ?></th>
                                        <th><?php echo app('translator')->get('Status'); ?></th>
                                        <th><?php echo app('translator')->get('Priority'); ?></th>
                                        <th><?php echo app('translator')->get('Last Reply'); ?></th>
                                        <th><?php echo app('translator')->get('Action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $supports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $support): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td><?php echo e($loop->index + $supports->firstItem()); ?></td>

                                            <td>
                                                <a class="fw-bold" href="<?php echo e(route('ticket.view', $support->ticket)); ?>"> [<?php echo app('translator')->get('Ticket'); ?>#<?php echo e($support->ticket); ?>] <?php echo e(__($support->subject)); ?> </a>
                                            </td>

                                            <td><?php echo $support->statusBadge; ?></td>

                                            <td>
                                                <?php if($support->priority == Status::PRIORITY_LOW): ?>
                                                    <span class="badge badge--dark"><?php echo app('translator')->get('Low'); ?></span>
                                                <?php elseif($support->priority == Status::PRIORITY_MEDIUM): ?>
                                                    <span class="badge badge--warning"><?php echo app('translator')->get('Medium'); ?></span>
                                                <?php elseif($support->priority == Status::PRIORITY_HIGH): ?>
                                                    <span class="badge badge--danger"><?php echo app('translator')->get('High'); ?></span>
                                                <?php endif; ?>
                                            </td>

                                            <td><?php echo e(diffForHumans($support->last_reply)); ?> </td>

                                            <td>
                                                <a class="btn btn-outline--base btn-sm" href="<?php echo e(route('ticket.view', $support->ticket)); ?>">
                                                    <i class="la la-desktop"></i> <?php echo app('translator')->get('View'); ?>
                                                </a>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td class="text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <?php if($supports->hasPages()): ?>
                        <div class="card-footer">
                            <?php echo e(paginateLinks($supports)); ?>

                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('bottom-menu'); ?>
    <li><a href="<?php echo e(route('user.profile.setting')); ?>"><?php echo app('translator')->get('Profile'); ?></a></li>
    <li><a href="<?php echo e(route('user.referral.users')); ?>"><?php echo app('translator')->get('Referral'); ?></a></li>
    <li><a href="<?php echo e(route('user.twofactor')); ?>"><?php echo app('translator')->get('2FA Security'); ?></a></li>
    <li><a href="<?php echo e(route('user.change.password')); ?>"><?php echo app('translator')->get('Change Password'); ?></a></li>
    <li><a href="<?php echo e(route('user.transaction.history')); ?>"><?php echo app('translator')->get('Transactions'); ?></a></li>
    <li><a class="active" href="<?php echo e(route('ticket.index')); ?>"><?php echo app('translator')->get('Support Tickets'); ?></a></li>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\viserbank\core\resources\views/templates/basic/user/support/index.blade.php ENDPATH**/ ?>