<?php
$kyc = getContent('kyc_content.content', true);
?>
<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class="row justify-content-center gy-4">
            <div class="col-lg-12">
                <?php if($user->kv == 0): ?>
                    <div class="card-widget section--bg2" role="alert">
                        <h4 class="text--base"><?php echo app('translator')->get('KYC Verification required'); ?></h4>
                        <hr>
                        <p class="mb-0 text-white"><?php echo e(__(@$kyc->data_values->unverified_content)); ?> <a href="<?php echo e(route('user.kyc.form')); ?>" class="text--base"><?php echo app('translator')->get('Click Here to Verify'); ?></a></p>
                    </div>
                <?php elseif(auth()->user()->kv == 2): ?>
                    <div class="card-widget section--bg2" role="alert">
                        <h4 class="text--base"><?php echo app('translator')->get('KYC Verification pending'); ?></h4>
                        <hr>
                        <p class="mb-0 text-white"><?php echo e(__(@$kyc->data_values->pending_content)); ?> <a href="<?php echo e(route('user.kyc.data')); ?>" class="text--base"><?php echo app('translator')->get('See KYC Data'); ?></a></p>
                    </div>
                <?php endif; ?>
            </div>
            <div class="col-lg-6">
                <div class="card-widget section--bg2 text-center bg_img" style="background-image: url(' <?php echo e(asset($activeTemplateTrue . 'images/elements/card-bg.png')); ?> ');">
                    <span class="caption text-white mb-3"><?php echo app('translator')->get('Account Number'); ?></span>
                    <h3 class="d-number text-white"><?php echo e($user->account_number); ?></h3>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="card-widget section--bg2 text-center bg_img" style="background-image: url(' <?php echo e(asset($activeTemplateTrue . 'images/elements/card-bg.png')); ?> ');">
                    <span class="caption text-white mb-3"><?php echo app('translator')->get('Available Balance'); ?></span>
                    <h3 class="d-number text-white"><?php echo e($general->cur_sym); ?><?php echo e(showAmount($user->balance)); ?></h3>
                </div>
            </div>

            <?php if(@$general->modules->deposit): ?>
                <div class="col-lg-4 col-md-6">
                    <a href="<?php echo e(route('user.deposit.history')); ?>" class="w-100 h-100">
                        <div class="d-widget section--bg2 d-flex flex-wrap align-items-center rounded-3 bg_img h-100" style="background-image: url(' <?php echo e(asset($activeTemplateTrue . 'images/elements/card-bg.png')); ?> ');">
                            <div class="d-widget__content">
                                <h3 class="d-number text-white">
                                    <?php echo e($general->cur_sym); ?><?php echo e(showAmount(@$widget['total_deposit'])); ?>

                                </h3>
                                <span class="caption text-white"><?php echo app('translator')->get('Deposits'); ?></span>
                            </div>
                            <div class="d-widget__icon border-radius--100">
                                <i class="las la-wallet"></i>
                            </div>
                        </div>
                    </a>
                </div>
            <?php endif; ?>
            <?php if(@$general->modules->withdraw): ?>
                <div class="col-lg-4 col-md-6">
                    <a href="<?php echo e(route('user.withdraw.history')); ?>" class="w-100 h-100">
                        <div class="d-widget section--bg2 d-flex flex-wrap align-items-center rounded-3 bg_img h-100" style="background-image: url(' <?php echo e(asset($activeTemplateTrue . 'images/elements/card-bg.png')); ?> ');">
                            <div class="d-widget__content">
                                <h3 class="d-number text-white"><?php echo e($general->cur_sym); ?><?php echo e(showAmount(@$widget['total_withdraw'])); ?></h3>
                                <span class="caption text-white"><?php echo app('translator')->get('Withdrawals'); ?></span>
                            </div>
                            <div class="d-widget__icon border-radius--100">
                                <i class="las la-money-check"></i>
                            </div>
                        </div>
                    </a>
                </div>
            <?php endif; ?>
            <div class="col-lg-4 col-md-6">
                <a href="<?php echo e(route('user.transaction.history')); ?>" class="w-100 h-100">
                    <div class="d-widget section--bg2 d-flex flex-wrap align-items-center rounded-3 bg_img h-100" style="background-image: url(' <?php echo e(asset($activeTemplateTrue . 'images/elements/card-bg.png')); ?> ');">
                        <div class="d-widget__content">
                            <h3 class="d-number text-white"><?php echo e(@$widget['total_trx']); ?></h3>
                            <span class="caption text-white"><?php echo app('translator')->get('Transactions'); ?></span>
                        </div>
                        <div class="d-widget__icon border-radius--100">
                            <i class="las la-exchange-alt"></i>
                        </div>
                    </div>
                </a>
            </div>
            <?php if($general->modules->fdr): ?>
                <div class="col-lg-4 col-md-6">
                    <a href="<?php echo e(route('user.fdr.list')); ?>" class="w-100 h-100">
                        <div class="d-widget section--bg2 d-flex flex-wrap align-items-center rounded-3 bg_img h-100" style="background-image: url(' <?php echo e(asset($activeTemplateTrue . 'images/elements/card-bg.png')); ?> ');">
                            <div class="d-widget__content">
                                <h3 class="d-number text-white"><?php echo e(@$widget['total_fdr']); ?></h3>
                                <span class="caption text-white"><?php echo app('translator')->get('FDR'); ?></span>
                            </div>
                            <div class="d-widget__icon border-radius--100">
                                <i class="las la-money-bill"></i>
                            </div>
                        </div>
                    </a>
                </div>
            <?php endif; ?>
            <?php if($general->modules->dps): ?>
                <div class="col-lg-4 col-md-6">
                    <a href="<?php echo e(route('user.dps.list')); ?>" class="w-100 h-100">
                        <div class="d-widget section--bg2 d-flex flex-wrap align-items-center rounded-3 bg_img h-100" style="background-image: url('<?php echo e(asset($activeTemplateTrue . 'images/elements/card-bg.png')); ?> ');">
                            <div class="d-widget__content">
                                <h3 class="d-number text-white"><?php echo e(@$widget['total_dps']); ?></h3>
                                <span class="caption text-white"><?php echo app('translator')->get('DPS'); ?></span>
                            </div>
                            <div class="d-widget__icon border-radius--100">
                                <i class="las la-box-open"></i>
                            </div>
                        </div>
                    </a>
                </div>
            <?php endif; ?>
            <?php if($general->modules->loan): ?>
                <div class="col-lg-4 col-md-6">
                    <a href="<?php echo e(route('user.loan.list')); ?>" class="w-100 h-100">
                        <div class="d-widget section--bg2 d-flex flex-wrap align-items-center rounded-3 bg_img h-100" style="background-image: url('<?php echo e(asset($activeTemplateTrue . 'images/elements/card-bg.png')); ?> ');">
                            <div class="d-widget__content">
                                <h3 class="d-number text-white"><?php echo e(@$widget['total_loan']); ?></h3>
                                <span class="caption text-white"><?php echo app('translator')->get('Loan'); ?></span>
                            </div>
                            <div class="d-widget__icon border-radius--100">
                                <i class="las la-hand-holding-usd"></i>
                            </div>
                        </div>
                    </a>
                </div>
            <?php endif; ?>
        </div>

        <?php if($general->modules->referral_system): ?>
            <div class="row gy-4 mt-3">
                <div class="col-12">
                    <div class="d-widget d-flex flex-wrap align-items-center rounded-3">
                        <label for="lastname" class="col-form-label"><?php echo app('translator')->get('My Referral Link'); ?>:</label>
                        <div class="input-group">
                            <input type="url" id="ref" value="<?php echo e(route('home') . '?reference=' . auth()->user()->username); ?>" class="form--control bg-transparent" readonly>
                            <button type="button" class="input-group-text bg--base copybtn border-0 text-white"><i class="fa fa-copy"></i> &nbsp; <?php echo app('translator')->get('Copy'); ?></button>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <div class="row gy-4 mt-3">
            <div class="col-lg-6">
                <h4 class="mb-3"><?php echo app('translator')->get('Latest Credits'); ?></h3>
                    <div class="custom--card">
                        <div class="card-body p-0">
                            <div class="table-responsive--md">
                                <table class="table custom--table mb-0">
                                    <thead>
                                        <tr>
                                            <th><?php echo app('translator')->get('S.N.'); ?></th>
                                            <th><?php echo app('translator')->get('Date'); ?></th>
                                            <th><?php echo app('translator')->get('Trx'); ?></th>
                                            <th><?php echo app('translator')->get('Amount'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__empty_1 = true; $__currentLoopData = $credits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $credit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <tr>
                                                <td><?php echo e(__($loop->iteration)); ?></td>
                                                <td>
                                                    <?php echo e(showDateTime($credit->created_at, 'd M, Y h:i A')); ?>

                                                </td>
                                                <td><?php echo e(__($credit->trx)); ?></td>
                                                <td class="fw-bold">
                                                    <?php echo e(showAmount($credit->amount)); ?> <?php echo e(__($general->cur_text)); ?>

                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <tr>
                                                <td colspan="100%" class="text-center"><?php echo e(__($emptyMessage)); ?></td>
                                            </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
            </div>
            <div class="col-lg-6">
                <h4 class="mb-3"><?php echo app('translator')->get('Latest Debits'); ?></h3>
                    <div class="custom--card">
                        <div class="card-body p-0">
                            <div class="table-responsive--md">
                                <table class="table custom--table mb-0">
                                    <thead>
                                        <tr>
                                            <th><?php echo app('translator')->get('S.N.'); ?></th>
                                            <th><?php echo app('translator')->get('Date'); ?></th>
                                            <th><?php echo app('translator')->get('Trx'); ?></th>
                                            <th><?php echo app('translator')->get('Amount'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__empty_1 = true; $__currentLoopData = $debits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $debit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <tr>
                                                <td><?php echo e(__($loop->iteration)); ?></td>
                                                <td><?php echo e(showDateTime($debit->created_at, 'd M, Y h:i A')); ?></td>
                                                <td><?php echo e(__($debit->trx)); ?></td>
                                                <td class="fw-bold">
                                                    <?php echo e(showAmount($debit->amount)); ?><?php echo e(__($general->cur_text)); ?>

                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <tr>
                                                <td colspan="100%" class="text-center"><?php echo e(__($emptyMessage)); ?></td>
                                            </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
            </div>
        </div>

    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        (function($) {
            $('.copybtn').on('click', function() {
                var copyText = $(this).siblings('#ref')[0];
                copyText.select();
                copyText.setSelectionRange(0, 99999);
                document.execCommand("copy");
                copyText.blur();
                $(this).addClass('copied');
                setTimeout(() => {
                    $(this).removeClass('copied');
                }, 1500);
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\viserbank\core\resources\views/templates/basic/user/dashboard.blade.php ENDPATH**/ ?>